<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerPermission extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'permission_id',
        'template_id',
        'status',
        'customer_id',
        'workspace_id',
        'module_id',
        'module_type',
        'template_id',
        'del',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the permission that owns this customer permission
     */
    public function permission()
    {
        return $this->belongsTo(Permission::class, 'permission_id', 'id');
    }

    /**
     * Get the module associated with this customer permission (when module_type is 'module')
     */
    public function module()
    {
        return $this->belongsTo(PermissionsModules::class, 'module_id', 'id');
    }

    /**
     * Get the sub-module associated with this customer permission (when module_type is 'sub_module')
     */
    public function subModule()
    {
        return $this->belongsTo(PermissionsSubModules::class, 'module_id', 'id');
    }

    /**
     * Get the module or sub-module based on module_type
     * Returns the appropriate relationship based on module_type field
     */
    public function getModuleOrSubModuleAttribute()
    {
        if ($this->module_type === 'sub_module') {
            return $this->subModule;
        }
        return $this->module;
    }

    /**
     * Get all employee permissions for this customer permission
     */
    public function employeePermissions()
    {
        return $this->hasMany(CustomerEmployeePermission::class, 'customer_permission_id', 'id');
    }

    /**
     * Get the customer that owns this permission
     */
    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    /**
     * Get the template that was used to assign this permission
     */
    public function template()
    {
        return $this->belongsTo(PermissionTemplate::class, 'template_id', 'id');
    }
}
