<?php

namespace App\Models;

class DefectHistory extends BaseModel
{
    protected $fillable = [
        'defect_id',
        'action',
        'description',
        'changed_by',
        'changed_by_type',
        'old_value',
        'new_value',
        'customer_id',
        'workspace_id',
    ];

    protected $casts = [
        'old_value' => 'array',
        'new_value' => 'array',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function defect()
    {
        return $this->belongsTo(Defect::class, 'defect_id');
    }
}

