<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentInjuryManagement extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_injury_managements';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'date',
        'time',
        'representative_name',
        'previous_injury_date',
        'injured_names',
        'is_first_aid',
        'is_referred',
        'is_doctor',
        'is_clinic',
        'is_admit',
        'return_to_work',
        'is_doctor_details',
        'doctor_name',
        'doctor_number',
        'doctor_address',
        'hospital_name',
        'hospital_number',
        'hospital_address',
        'incident_response',
        'is_recurrence_injury',
        'previous_report_number',
        'is_hospital_details',
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }
}
