<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentInjuryType extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_injury_types';

    // Define fillable fields
    protected $fillable = [
        'title',
        'description',
        'parent_id',
        'status',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    // Define self-referential relationship (if hierarchical injury types exist)
    public function parent()
    {
        return $this->belongsTo(IncidentInjuryType::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(IncidentInjuryType::class, 'parent_id');
    }
}
