<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportNotifiableClassification extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_report_notifiable_classifications';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'notifiable_classification_id',
        'injury_classification_id'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function notifiableClassification()
    {
        return $this->belongsTo(IncidentNotifiableClassification::class, 'notifiable_classification_id');
    }
}
