<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingAttendance extends BaseModel
{
    use HasFactory;

    public function employee_details()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting()
    {
        return $this->belongsTo(Meeting::class,'meeting_id', 'id')->with('meeting_site')->select('id','site_id','agenda');
    }
}
