<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingDocument extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'meeting_id',
        'title',
        'document_path',
        'uploaded_by',
        'meeting_date',
        'is_signed',
        'is_daily',
        'meeting_notes',
        'type'
    ];

    public function employee_signed_document()
    {
        return $this->hasMany(EmployeeSignedDocument::class,'document_id','id');
    }

    public function shouldShowToday($currentDate = null)
    {
        if ($currentDate === null) {
            $currentDate = date('Y-m-d');
        }

        // If document is marked as daily, show it every day
        if ($this->is_daily == 1) {
            return true;
        }

        // If document has a specific meeting_date, only show on that date
        if ($this->meeting_date) {
            return $this->meeting_date == $currentDate;
        }

        // Default behavior: show if no meeting_date (legacy documents)
        return true;
    }

    public function isSignedByEmployeeToday($employeeId, $currentDate = null)
    {
        if ($currentDate === null) {
            $currentDate = date('Y-m-d');
        }

        return $this->employee_signed_document()
            ->where('employee_id', $employeeId)
            ->where('date', $currentDate)
            ->where('signed', 1)
            ->exists();
    }
}
