<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingOrganiser extends BaseModel
{
    use HasFactory;

    // Corrected the typo from "fillble" to "fillable"
    protected $fillable = [
        'meeting_id',
        'site_id',
        'organiser_id',
    ];

    public function organiser()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'organiser_id')
            ->select('id', 'emp_id', 'first_name', 'middle_name', 'last_name', 'image');
    }
}
