<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payroll extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'pay_year',
        'pay_month',
        'basic_salary',
        'working_hours',
        'hours_spent',
        'actual_working_hours',
        'overtime_hours',
        'calculated_salary',
        'status',
        'pdf_path',
        'attendance_pdf_path',
        'customer_id',
        'workspace_id',
        'created_by'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }
    
    public function employeCom()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id', 'id');
    }
    

}
