<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Permission extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'module_id',
        'module_type',
        'status',
        'permission_code',
        'del',
    ];

    protected $hidden = [];

    /**
     * Get all customer permissions for this permission
     */
    public function customerPermissions()
    {
        return $this->hasMany(CustomerPermission::class, 'permission_id', 'id');
    }

    /**
     * Get the module relationship (when module_type is 'module')
     */
    public function module()
    {
        return $this->belongsTo(PermissionsModules::class, 'module_id', 'id');
    }

    /**
     * Get the sub-module relationship (when module_type is 'sub_module')
     */
    public function subModule()
    {
        return $this->belongsTo(PermissionsSubModules::class, 'module_id', 'id');
    }

    /**
     * Get the module or sub-module based on module_type
     * Returns the appropriate relationship based on module_type field
     */
    public function moduleOrSubModule()
    {
        if ($this->module_type === 'sub_module') {
            return $this->belongsTo(PermissionsSubModules::class, 'module_id', 'id');
        }
        return $this->belongsTo(PermissionsModules::class, 'module_id', 'id');
    }

    /**
     * Accessor to get module or sub-module
     */
    public function getModuleOrSubModuleAttribute()
    {
        if ($this->module_type === 'sub_module') {
            return $this->subModule;
        }
        return $this->module;
    }

    /**
     * Get all templates that include this permission
     */
    public function templates()
    {
        return $this->belongsToMany(PermissionTemplate::class, 'permission_template_items', 'permission_id', 'template_id')
            ->where('permission_templates.del', '0')
            ->withTimestamps();
    }
}
