<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class PermissionTemplate extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'status',
        'created_by',
        'del',
    ];

    /**
     * Get all permissions in this template
     */
    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_template_items', 'template_id', 'permission_id')
            ->where('permissions.del', '0')
            ->withTimestamps();
    }

    /**
     * Get all template items
     */
    public function templateItems()
    {
        return $this->hasMany(PermissionTemplateItem::class, 'template_id', 'id');
    }

    /**
     * Get all customer permissions assigned via this template
     */
    public function customerPermissions()
    {
        return $this->hasMany(CustomerPermission::class, 'template_id', 'id')
            ->where('del', '0');
    }

    /**
     * Get the admin user who created this template
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
