<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class PermissionTemplateItem extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'template_id',
        'permission_id',
    ];

    /**
     * Get the template this item belongs to
     */
    public function template()
    {
        return $this->belongsTo(PermissionTemplate::class, 'template_id', 'id');
    }

    /**
     * Get the permission
     */
    public function permission()
    {
        return $this->belongsTo(Permission::class, 'permission_id', 'id');
    }
}
