<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PermissionsSubModules extends BaseModel
{
    use HasFactory;

    protected $fillable = ['title','module_id','image','priority','link'];

    /**
     * Get the parent module
     */
    public function module()
    {
        return $this->belongsTo(PermissionsModules::class, 'module_id', 'id');
    }

    /**
     * Get all customer permissions for this sub-module
     */
    public function customerPermissions()
    {
        return $this->hasMany(CustomerPermission::class, 'module_id', 'id')
            ->where('module_type', 'sub_module');
    }

    /**
     * Get all customer employee permissions for this sub-module
     */
    public function customerEmployeePermissions()
    {
        return $this->hasMany(CustomerEmployeePermission::class, 'module_id', 'id')
            ->where('module_type', 'sub_module');
    }

    /**
     * Get all permissions for this sub-module (where module_type is 'sub_module')
     */
    public function permissions()
    {
        return $this->hasMany(Permission::class, 'module_id', 'id')
            ->where('module_type', 'sub_module')
            ->where('del', '0');
    }
}
