<?php

namespace App\Models;

class ProjectManagementDocument extends BaseModel
{
    protected $table = 'project_management_dacuments'; // Note: table name has typo "dacuments"

    protected $fillable = [
        'project_management_id',
        'document_name',
        'document_path',
        'comment',
        'uploaded_by',
        'uploaded_by_type',
        'customer_id',
        'workspace_id',
        'del',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    // Relationships
    public function projectManagement()
    {
        return $this->belongsTo(ProjectManagement::class, 'project_management_id');
    }

    public function uploadedByUser()
    {
        if ($this->uploaded_by_type === 'internal_employee') {
            return $this->belongsTo(EmpPersonalDetails::class, 'uploaded_by', 'emp_id')
                ->select('emp_id', 'first_name', 'middle_name', 'last_name');
        } elseif ($this->uploaded_by_type === 'subcontractor') {
            return $this->belongsTo(User::class, 'uploaded_by')
                ->select('id', 'name', 'email', 'mobile_number', 'company_name');
        } elseif ($this->uploaded_by_type === 'subcontractor_employee') {
            return $this->belongsTo(EmployeeSubcontractor::class, 'uploaded_by', 'id')
                ->select('id', 'first_name', 'middle_name', 'last_name', 'email');
        }
        return null;
    }

    // Accessor for full document URL
    public function getDocumentUrlAttribute()
    {
        if ($this->document_path) {
            return url($this->document_path);
        }
        return null;
    }
}

