<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Referral extends BaseModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'contact_number',
        'referral_code',
        'referral_link',
        'created_by',
    ];

    /**
     * Get the leads for the referral.
     */
    public function leads()
    {
        return $this->hasMany(Lead::class);
    }

    /**
     * Get the user who created this referral.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
} 