<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;

class SiteDiaryEquipment extends BaseModel
{
    use SoftDeletes;
    protected $table = 'site_diary_equipment';

    protected $fillable = [
        'site_diary_id',
        'equipment_name',
        'quantity',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];


    // Log relationship
    public function logs()
    {
        return $this->morphMany(SiteDiaryLog::class, 'loggable');
    }

    // Relationships
    public function siteDiary()
    {
        return $this->belongsTo(SiteDiary::class, 'site_diary_id');
    }
}