<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SiteDocumentSignature extends BaseModel
{
    use HasFactory;

    protected $table = 'site_document_signatures';

    protected $fillable = [
        'site_document_id',
        'employee_id',
        'site_id',
        'user_type',
        'customer_id',
        'workspace_id',
        'signature',
        'signed_at'
    ];

    protected $casts = [
        'signed_at' => 'datetime',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function siteDocument()
    {
        return $this->belongsTo(SiteDocument::class, 'site_document_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id');
    }

    public function empPersonalDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }

    public function site()
    {
        return $this->belongsTo(Sites::class, 'site_id');
    }

    public function attendance()
    {
        return $this->belongsTo(EmployeeAttendance::class, 'attendance_id');
    }
}

