<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderLineItem extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tender_id',
        'description',
        'unit',
        'quantity',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the tender that owns this line item.
     */
    public function tender()
    {
        return $this->belongsTo(Tender::class, 'tender_id');
    }

    /**
     * Get all bids for this line item.
     */
    public function bids()
    {
        return $this->hasMany(TenderLineItemsBid::class, 'tender_line_items_id');
    }
}

