<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderLineItemsBid extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tender_id',
        'tender_line_items_id',
        'user_id',
        'bid_price',
        'status',
        'total_base_bid',
        'exclusions_clarifications',
        'is_late_submission',
        'submitted_at',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the tender associated with this bid.
     */
    public function tender()
    {
        return $this->belongsTo(Tender::class, 'tender_id');
    }

    /**
     * Get the line item associated with this bid.
     */
    public function lineItem()
    {
        return $this->belongsTo(TenderLineItem::class, 'tender_line_items_id');
    }

    /**
     * Get the user who placed this bid.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}

