<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderRfi extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tender_id',
        'user_id',
        'question',
        'answer',
        'status',
        'answered_at',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the tender associated with this RFI.
     */
    public function tender()
    {
        return $this->belongsTo(Tender::class, 'tender_id');
    }

    /**
     * Get the user who created this RFI.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}

