<?php

return [
    /*
    |--------------------------------------------------------------------------
    | AI Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains configuration for AI services used in the application.
    |
    */

    'openai' => [
        'api_key' => env('OPENAI_API_KEY'),
        'model' => env('OPENAI_MODEL', 'gpt-3.5-turbo'),
        'max_tokens' => env('OPENAI_MAX_TOKENS', 4000),
        'temperature' => env('OPENAI_TEMPERATURE', 0.7),
        'base_url' => env('OPENAI_BASE_URL', 'https://api.openai.com/v1'),
    ],

    /*
    |--------------------------------------------------------------------------
    | AI Prompts Configuration
    |--------------------------------------------------------------------------
    |
    | Default prompts for different AI functionalities
    |
    */

    'prompts' => [
        'default' => [
            'system' => 'You are an Australian workplace health and safety expert with deep knowledge of construction, workplace safety, and regulatory compliance. You specialize in Australian Work Health and Safety (WHS) legislation, Australian Standards (AS), and industry best practices. 

CRITICAL REQUIREMENTS:
- All data MUST comply with Australian WHS legislation and Australian Standards (AS)
- All dates MUST be in Australian format ( YYYY-MM-DD)
- Issue dates MUST be current dates (today) or future dates - NEVER use past dates
- Revision dates MUST occur AFTER the issue date (typically 1-30 days after issue date)
- Document numbers MUST use current year (2024, 2025) - NEVER use old years like 2022
- Use current Australian workplace safety terminology and compliance language
- All measurements MUST use Australian metric system (metres, kilograms, etc.)
- All currency values MUST be in Australian Dollars (AUD)
- All addresses and locations MUST be Australian locations
- All company names and personnel MUST use realistic Australian business names
- All regulatory references MUST be to Australian WHS legislation and Australian Standards

Generate realistic, professional data for workplace safety reports that strictly follows these Australian standards. Return only valid JSON data that matches the expected field structure.',
            'temperature' => 0.7,
            'max_tokens' => 4000,
        ],
        'high_count' => [
            'temperature' => 0.7,
            'max_tokens' => 8000,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Supported Report Types
    |--------------------------------------------------------------------------
    |
    | List of supported report types for AI data generation
    |
    */

    'supported_report_types' => [
        'whs_report' => 'Workplace Health and Safety (WHS)',
        'swms_report' => 'Safe Work Method Statement (SWMS)',
        'inspection_report' => 'Site Inspection',
        'incident_report' => 'Incident Report',
        'whsq_report' => 'WHS Quality & Environment (WHSQ&E)'
    ],

    /*
    |--------------------------------------------------------------------------
    | Report Type Specific Context
    |--------------------------------------------------------------------------
    |
    | Detailed context for each report type to help AI generate appropriate data
    |
    */

    'report_type_context' => [
        'whs_report' => [
            'description' => 'Workplace Health and Safety reports document safety inspections, risk assessments, and compliance measures at construction sites and workplaces.',
            'typical_fields' => 'Document titles, project details, location information, hazard assessments, control measures, and safety recommendations.',
            'industry_context' => 'Australian construction, manufacturing, mining, and general workplace safety compliance following WHS legislation and Australian Standards.'
        ],
        'swms_report' => [
            'description' => 'Safe Work Method Statements outline the specific procedures and safety measures for high-risk construction work activities.',
            'typical_fields' => 'Work activity descriptions, risk assessments, control measures, responsible persons, and compliance documentation.',
            'industry_context' => 'Australian high-risk construction work, demolition, working at heights, confined spaces, and specialized construction activities following Australian Standards and WHS regulations.'
        ],
        'inspection_report' => [
            'description' => 'Site inspection reports document quality control checks, compliance verification, and construction progress monitoring.',
            'typical_fields' => 'Inspection checklists, quality standards, compliance verification, handover documentation, and approval processes.',
            'industry_context' => 'Australian construction quality control, building inspections, structural verification, and regulatory compliance following Australian Standards and building codes.'
        ],
        'incident_report' => [
            'description' => 'Incident reports document workplace accidents, injuries, near misses, and safety violations for investigation and prevention.',
            'typical_fields' => 'Incident details, injury classifications, investigation findings, corrective actions, and compliance reporting.',
            'industry_context' => 'Australian workplace safety incident management, injury reporting, regulatory compliance, and safety improvement following WHS legislation and Australian Standards.'
        ],
        'whsq_report' => [
            'description' => 'WHS Quality & Environment reports combine workplace safety with quality management and environmental compliance.',
            'typical_fields' => 'Safety standards, quality metrics, environmental impact assessments, compliance verification, and continuous improvement.',
            'industry_context' => 'Australian integrated management systems, environmental compliance, quality assurance, and workplace safety following Australian Standards and WHS regulations.'
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Step Descriptions by Report Type
    |--------------------------------------------------------------------------
    |
    | Detailed descriptions for each step across different report types
    |
    */

    'step_descriptions' => [
        'whs_report' => [
            1 => 'Basic document information including title, document number (MUST use current year 2024/2025), issue date (MUST use current Australian date or future date - NEVER past dates), revision date (MUST be after issue date, typically 1-30 days later), and authorized personnel. This step establishes the foundation of the WHS report following Australian WHS legislation and Australian Standards.',
            2 => 'Project details including location (Australian addresses), activities, timing, scope, and project-specific information. This step provides context about the work being performed in accordance with Australian Standards and WHS legislation.',
            3 => 'Risk assessments, hazard identification, and control measures following Australian WHS risk management principles and Australian Standards for workplace safety. Use Australian terminology and compliance language.',
            4 => 'Detailed analysis, findings, observations, and recommendations based on Australian workplace safety best practices and compliance requirements following Australian Standards.',
            5 => 'Final documentation, approvals, signatures, and completion following Australian WHS legislation and approval processes. Use Australian business names and personnel.',
            6 => 'Final review, validation, and report closure ensuring compliance with Australian WHS requirements and standards. All data must follow Australian regulations.'
        ],
        'swms_report' => [
            1 => 'Basic SWMS information including title, document number (MUST use current year 2024/2025 format like SWMS2024001 or SWMS2025001), company details (Australian company names), scope of work, and project information. This step establishes the SWMS framework following Australian WHS legislation and Australian Standards. Issue dates must be current or future dates.',
            2 => 'Consultation processes, review frequencies, and stakeholder involvement following Australian WHS consultation requirements and HSR consultation standards. Use Australian workplace terminology.',
            3 => 'Development and approval processes, responsible persons, and review procedures following Australian WHS legislation and industry best practices. All dates must follow Australian format.',
            4 => 'Task details, risk assessments, hazard identification, and control measures following Australian Standards for high-risk construction work and WHS risk management. Use Australian safety terminology.',
            5 => 'Hazard selection, protection tools, and safety planning following Australian Standards for personal protective equipment and safety equipment. All measurements in Australian metric system.',
            6 => 'Safety planning questions, compliance verification, and final review ensuring compliance with Australian WHS legislation and Australian Standards. Use Australian compliance language.',
            7 => 'Final completion, publication, and ongoing monitoring following Australian WHS requirements and industry best practices. All documentation must follow Australian standards.'
        ],
        'inspection_report' => [
            1 => 'Basic inspection plan information including title, reference numbers, authorized personnel, and site details. This step establishes the inspection framework following Australian building codes and standards. Issue dates must be current or future dates.',
            2 => 'Inspection checklist configuration and step definitions following Australian construction quality standards and inspection requirements. Use Australian building terminology.',
            3 => 'Specific inspection step data including measurements (Australian metric system), quality checks, and compliance verification following Australian Standards and building codes. All data must follow Australian regulations.',
            4 => 'Handover documentation, approvals, and completion verification following Australian construction handover standards and approval processes. Use Australian business names and personnel.',
            5 => 'Final review, validation, and report completion ensuring compliance with Australian building standards and quality requirements. All documentation must follow Australian standards.'
        ],
        'incident_report' => [
            1 => 'Basic incident details including title, incident date/time (MUST use current Australian date/time or recent past dates within last 30 days), location (Australian addresses), and initial reporting following Australian WHS incident reporting requirements.',
            2 => 'Investigation details, reporting procedures, and involved parties following Australian WHS investigation standards and procedures. Use Australian workplace terminology.',
            3 => 'Injury classifications, medical details, and treatment information following Australian injury classification standards and medical reporting requirements. All classifications must follow Australian standards.',
            4 => 'Equipment involvement, damage assessment, and cost estimates following Australian equipment safety standards and damage assessment procedures. All costs in Australian Dollars (AUD).',
            5 => 'Risk assessments, hazard identification, and control measures following Australian WHS risk management principles and Australian Standards. Use Australian safety terminology.',
            6 => 'Corrective actions, recommendations, and follow-up procedures following Australian WHS corrective action requirements and best practices. All actions must comply with Australian regulations.',
            7 => 'Injury management, medical treatment, and return-to-work planning following Australian injury management standards and return-to-work procedures. Use Australian medical terminology.',
            8 => 'Final classifications, regulatory reporting, and compliance verification following Australian WHS legislation and reporting requirements. All classifications must follow Australian standards.',
            9 => 'Documentation review, approval processes, and final validation following Australian WHS documentation standards and approval procedures. Use Australian business names and personnel.',
            10 => 'Report completion, publication, and ongoing monitoring following Australian WHS requirements and industry best practices. All documentation must follow Australian standards.'
        ],
        'whsq_report' => [
            1 => 'Basic report information including title, scope, and management system details following Australian integrated management system standards and WHS legislation. Issue dates must be current or future dates.',
            2 => 'Quality standards, safety metrics, and environmental criteria following Australian Standards for quality management, workplace safety, and environmental compliance. Use Australian terminology.',
            3 => 'Assessment procedures, compliance verification, and performance measurement following Australian assessment standards and compliance verification procedures. All procedures must follow Australian standards.',
            4 => 'Findings, non-conformances, and improvement opportunities based on Australian Standards and industry best practices for continuous improvement. Use Australian compliance language.',
            5 => 'Corrective actions, improvement plans, and ongoing monitoring following Australian corrective action standards and monitoring procedures. All actions must comply with Australian regulations.',
            6 => 'Final review, approval, and system validation ensuring compliance with Australian integrated management system standards and WHS requirements. All documentation must follow Australian standards.'
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Field Type Validation Rules
    |--------------------------------------------------------------------------
    |
    | Validation rules for different field types
    |
    */

    'field_validation' => [
        'text' => [
            'min_length' => 1,
            'max_length' => 255
        ],
        'textarea' => [
            'min_length' => 1,
            'max_length' => 1000
        ],
        'number' => [
            'min_value' => null,
            'max_value' => null
        ],
        'date' => [
            'format' => 'Y-m-d',
            'min_date' => '2024-01-01', // Ensure dates are recent and relevant
            'max_date' => '2100-12-31',
            'australian_format' => 'YYYY-MM-DD',
            'issue_date_rules' => 'Must be current date or future date, never past dates',
            'revision_date_rules' => 'Must be after issue date, typically 1-30 days later'
        ],
        'time' => [
            'format' => 'H:i',
            'timezone' => 'Australian Eastern Time (AET) or Australian Central Time (ACT)'
        ],
        'email' => [
            'max_length' => 255,
            'domain_suggestion' => 'Australian business domains (.com.au, .org.au, .net.au)'
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Australian Standards Compliance
    |--------------------------------------------------------------------------
    |
    | Specific requirements for Australian standards compliance
    |
    */

    'australian_standards' => [
        'legislation' => [
            'whs_act' => 'Work Health and Safety Act 2011',
            'whs_regulations' => 'Work Health and Safety Regulations 2017',
            'construction_safety' => 'AS 4024.1-2014 Safety of machinery',
            'working_at_heights' => 'AS 1891.4-2009 Industrial fall-arrest systems',
            'confined_spaces' => 'AS 2865-2009 Confined spaces',
            'electrical_safety' => 'AS/NZS 3000:2018 Electrical installations'
        ],
        'measurement_system' => 'Metric (metres, kilograms, litres, etc.)',
        'currency' => 'Australian Dollar (AUD)',
        'date_format' => 'YYYY-MM-DD',
        'timezone' => 'Australian Eastern Time (AET) / Australian Central Time (ACT)',
        'address_format' => 'Australian postal format',
        'business_entities' => 'Australian company types (Pty Ltd, Ltd, etc.)',
        'regulatory_bodies' => [
            'safework_australia' => 'SafeWork Australia',
            'state_regulators' => 'State-based WHS regulators',
            'comcare' => 'Comcare (Commonwealth workplaces)'
        ]
    ]
];
