<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'recaptcha' => [
        'secret' => env('RECAPTCHA_SECRET_KEY' , "6LfB9hMsAAAAAIQsCzFzMtXAt3TDWzn2bo4EKG-0"),
    ],

    'xero' => [
        // These three match the Postman \"environment variables\" in the Xero guide
        'redirect_uri' => env('XERO_REDIRECT_URI', env('APP_URL') . '/api/redirect'),

        // Scopes as per Xero/Postman guide; can be overridden via XERO_SCOPES in .env
        // Example default includes: offline_access accounting.transactions openid profile email accounting.contacts accounting.settings payroll.employees payroll.payruns payroll.settings payroll.timesheets
        'scopes' => env(
            'XERO_SCOPES',
            'offline_access accounting.transactions openid profile email accounting.contacts accounting.settings payroll.employees payroll.payruns payroll.settings payroll.timesheets'
        ),
    ],

    'gohighlevel' => [
        'api_key' => env('GOHIGHLEVEL_API_KEY'),
        'location_id' => env('GOHIGHLEVEL_LOCATION_ID'),
        'pipeline_id' => env('GOHIGHLEVEL_PIPELINE_ID', null),
        'stage_id' => env('GOHIGHLEVEL_STAGE_ID', null),
    ],

];
