<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whsqe_table_of_content_meta', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('whsq_report_id')->nullable();
            $table->unsignedBigInteger('step_id')->nullable();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->unsignedBigInteger('child_id')->nullable();
            $table->unsignedBigInteger('grandchild_id')->nullable();
            $table->text('content')->nullable();
            $table->json('dynamic_inputs')->nullable(); // For checkboxes, dates, etc.
            $table->string('image_path')->nullable(); // Path to stored image
            $table->string('image_alt')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('start_new')->default(false); // Flag for starting on new page in PDF
            $table->integer('deleted_at')->default(0);
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('workspace_id')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['whsq_report_id', 'step_id'], 'whsq_meta_report_step_idx');
            $table->index(['customer_id', 'workspace_id'], 'whsq_meta_customer_workspace_idx');
            $table->index(['parent_id', 'child_id', 'grandchild_id'], 'whsq_meta_hierarchy_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whsqe_table_of_content_meta');
    }
}; 