<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_reports', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->integer('customer_id')->nullable(); 
            $table->integer('workspace_id')->nullable(); 
            $table->string('document_number')->nullable();
            $table->integer('authorised_by')->default(0);
            $table->integer('revision_number')->default(0);
            $table->integer('site_id')->default(0);
            $table->string('issue_date')->nullable();
            $table->string('revision_date')->nullable();
            $table->integer('parent_number')->default(0);
            $table->string('investigation_number')->nullable();
            $table->string('office_number')->nullable();
            $table->integer('project_id')->default(0);
            $table->string('project_name')->nullable();
            $table->integer('project_number')->default(0);
            $table->integer('report_compiled_by')->default(0);
            $table->integer('position_id')->default(0);
            $table->integer('is_questions')->nullable();
            $table->string('date')->nullable();
            $table->string('incident_date')->nullable();
            $table->string('incident_time')->nullable();
            $table->string('date_incident_reported')->nullable();
            $table->string('time_incident_reported')->nullable();
            $table->integer('is_notified')->default(0);
            $table->integer('is_notified_to')->default(0);
            $table->integer('is_victim')->nullable();
            $table->integer('involved_persons')->default(0);
            $table->integer('is_extra_questions')->default(0);
            $table->integer('is_plant_involved')->default(0);
            $table->integer('is_correct_action_required')->default(0);
            $table->integer('plant_name')->default(0);
            $table->integer('is_injury_management')->default(0);
            $table->integer('is_final_injury_classification')->default(0);
            $table->integer('is_final_incident_classification')->default(0);
            $table->integer('lti_or_rwi')->default(0);
            $table->text('incident_response')->nullable();
            $table->integer('approval_status')->default(0)->nullable();
            $table->integer('del')->default(0);
            $table->integer('process')->default(0);
            $table->integer('step_no')->default(2);
            $table->enum('is_published', ['0', '1'])->default('0');
            $table->integer('report_method')->default(0);
            $table->integer('send_by')->nullable();
            $table->string('sender_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_reports');
    }
}
