<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentNotifiedTosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_notified_tos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->integer('notified_to')->default(0);
            $table->integer('ohs_regulator')->default(0);
            $table->integer('reference_number')->default(0);
            $table->string('date')->nullable();
            $table->string('time')->nullable();
            $table->string('contact_name')->nullable();
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_notified_tos');
    }
}
