<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentReportMetasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_report_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->string('equipment_type')->nullable();
            $table->string('registration_number')->nullable();
            $table->string('damage')->nullable();
            $table->string('cost')->nullable();   
            $table->string('shift_type')->nullable();
            $table->string('shift_time')->nullable();
            $table->text('incident_response')->nullable();      
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_report_metas');
    }
}
