<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('swms_number')->nullable();
            $table->string('title')->nullable();
            $table->longText('description')->nullable();
            $table->text('workplace_location_address')->nullable();
            $table->string('revision_number')->nullable();
            $table->string('version_number')->nullable();
            $table->date('start_date')->nullable();
            $table->string('company_name')->nullable();
            $table->string('company_address')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('scope_of_work')->nullable();
            $table->string('site_manager_or_forman')->nullable();
            $table->string('principal_contractor')->nullable();
            $table->string('principal_contractor_address')->nullable();
            $table->string('principal_contractor_number')->nullable();
            $table->string('fast_address')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('parent_id')->nullable();
            $table->integer('approval_status')->default(0)->nullable();
            $table->enum('del', [0, 1])->default(0);
            $table->enum('process', [0, 1])->default(0);
            $table->enum('published', [0, 1])->default(1);
            $table->integer('report_method')->default(0);
            $table->integer('send_by')->nullable();
            $table->string('sender_type')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms');
    }
}
