<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsMetasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id');
            $table->string('consultation_method')->nullable();
            $table->string('review_frequency')->nullable();
            $table->date('recieved_date')->nullable();
            $table->date('date_recieved_by_reviewer')->nullable();
            $table->string('is_based_on_risk')->nullable();
            $table->string('is_worker_consulted')->nullable();
            $table->string('person_responsible_for_reviewing_swms')->nullable();
            $table->string('person_responsible_for_ensuring_compliance')->nullable();
            $table->string('is_hsr_consulted')->nullable();
            $table->timestamps();
            $table->foreign('swms_id')->references('id')->on('swms')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_metas');
    }
}
