<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsTaskDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_task_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id')->nullable();
            $table->string('responsible_preson_id')->nullable();
            $table->text('job_task')->nullable();
            $table->string('image')->nullable();
            $table->string('hazard')->nullable();

            $table->string('risk')->nullable();
            $table->string('initial_risk_rating')->nullable();
            $table->string('controle_risk_ratting')->nullable();
            $table->longText('control_measure')->nullable();
            $table->string('final_risk_ratting')->nullable();
            $table->enum('del', [0, 1])->default(0);
            $table->timestamps();
            $table->foreign('swms_id')->references('id')->on('swms')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_task_details');
    }
}
