
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhsReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whs_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('swms_id')->nullable(); //swms id
            $table->unsignedInteger('authorised_by')->nullable(); //Emp id
            $table->unsignedInteger('project_id')->nullable(); //project id
            $table->unsignedInteger('additional_attending_inspections_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->unsignedInteger('site_id')->default(0);
            $table->unsignedInteger('conducted_by')->nullable();
            $table->unsignedInteger('created_by')->nullable(); //swms id
            $table->string('title')->nullable();
            $table->string('number')->nullable();
            $table->string('revision_number')->nullable();
            $table->date('issue_date')->nullable();
            $table->date('revision_date')->nullable();
            $table->string('priority')->nullable();
            $table->date('date')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->string('conducted_by_position')->nullable();
            $table->string('location')->nullable();
            $table->text('activities')->nullable();
            $table->text('general_notes')->nullable();
            $table->integer('approval_status')->default(0)->nullable();
            $table->string('del')->default(0);
            $table->string('status')->default(0);
            $table->string('is_published')->default(0);
            $table->integer('report_method')->default(0);
            $table->integer('send_by')->nullable();
            $table->string('sender_type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whs_reports');
    }
}
