<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingNoteDocumentsPdfsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meeting_note_documents_pdfs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('meeting_id')->nullable();
            $table->unsignedBigInteger('meeting_note_id')->nullable();

            $table->string('document_path')->nullable();
            $table->string('title')->nullable();
            $table->date('meeting_date')->nullable();
            $table->integer('uploaded_by')->nullable();
            $table->integer('status')->nullable();
            $table->string('is_signed')->nullable();
            $table->string('type')->nullable();
            $table->string('type_of_setting')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meeting_note_documents_pdfs');
    }
}
