<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddInductionStatusToSubcontractorCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     * 
     * This migration adds an induction_status column to track induction document signing status:
     * - 0 = Induction documents NOT signed (default)
     * - 1 = All induction documents signed (complete)
     * - 2 = Induction documents were signed, but company added NEW documents after that (major update)
     *
     * Note: Minor updates do NOT require re-signing, only major updates reset the status to 2.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->tinyInteger('induction_status')->default(0)
                ->comment('0=not signed, 1=complete, 2=new docs added (major update)')
                ->after('required_docs_status');
            
            // Add index for faster queries
            $table->index('induction_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->dropIndex(['induction_status']);
            $table->dropColumn('induction_status');
        });
    }
}
