<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddForceResetToEmployeesSubcontractorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees_subcontractors', function (Blueprint $table) {
            $table->integer('force_reset')->default(1);
        });
        // Removed invitation_accepted column - invitation status is tracked in subcontractor_employee_invitations table
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees_subcontractors', function (Blueprint $table) {
            $table->dropColumn('force_reset');
        });
    }
}

