<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fines', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id')->nullable();
            $table->date('date');
            $table->decimal('fine_amount', 10, 2)->nullable();
            $table->string('fine_reason', 500)->nullable();
            $table->tinyInteger('type')->default(0)->comment('0 = Fine, 1 = Bonus');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->timestamps();

            // Indexes
            $table->index(['employee_id', 'date']);
            $table->index(['customer_id', 'workspace_id']);
            $table->index('type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fines');
    }
}
