<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReferralClicksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('referral_clicks', function (Blueprint $table) {
            $table->id();
            $table->string('referral_code')->nullable();
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamp('clicked_at')->nullable();
            $table->timestamps();

            // Unique constraint to prevent duplicate clicks from same IP for same referral
            $table->unique(['referral_code', 'ip_address', 'user_agent']);
        });
        Schema::table('users', function (Blueprint $table) {
            $table->integer('referral_clicks')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('referral_clicks');
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('referral_clicks');
        });
    }
}
