<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSiteDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_documents', function (Blueprint $table) {
            $table->id();
            $table->integer('site_id');
            $table->string('title');
            $table->integer('document_type')->nullable();
            $table->string('file')->nullable();
            $table->string('uploaded_by');
            $table->enum('uploaded_by_type', ['customer', 'emp'])->default('customer');
            $table->json('role_ids')->nullable(); // Store array of role IDs
            $table->json('subcontractors')->nullable();
            $table->integer('sign_requires')->nullable()->default(0)->comment('0 = No signature required, 1 = Signature required');
            $table->integer('signature_timing')->nullable()->default(0)->comment('0 = At sign in, 1 = Can be done later');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_documents');
    }
}
