<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInductionDocumentSignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('induction_document_signatures', function (Blueprint $table) {
            $table->id();
            $table->integer('induction_document_id')->nullable();
            $table->string('document_version', 10)->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('signature_type')->nullable();
            $table->string('signature_path')->nullable();
            $table->timestamp('signed_at')->nullable();
            $table->boolean('is_valid')->default(true)->nullable();
            $table->text('notes')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->enum('del', [0, 1])->default(0)->nullable();
            $table->timestamps();
            
         
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('induction_document_signatures');
    }
}
