<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubcontractorRequiredDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     * 
     * This table stores the required documents uploaded by subcontractors for each company.
     * Each row represents a field value for a required document uploaded by a subcontractor.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subcontractor_required_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('subcontractor_id')->comment('User ID of the subcontractor');
            $table->unsignedBigInteger('customer_id')->comment('Customer/Company ID');
            $table->unsignedBigInteger('workspace_id')->nullable()->comment('Workspace ID');
            $table->unsignedBigInteger('required_document_id')->comment('Reference to required_documents table');
            $table->unsignedBigInteger('required_document_field_id')->nullable()->comment('Reference to required_document_fields table');
            $table->text('value')->nullable()->comment('The text value or file path');
            $table->text('rejection_reason')->nullable()->comment('Reason for rejection when required_docs_status = 3');
            $table->string('del')->default('0');
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('subcontractor_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('required_document_id')->references('id')->on('required_documents')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subcontractor_required_documents');
    }
}

