<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRejectionReasonToSubcontractorCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->text('rejection_reason')->nullable()->after('required_docs_status')->comment('Reason for rejection when required_docs_status = 3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->dropColumn('rejection_reason');
        });
    }
}
