<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DropEmpSubcontractorsTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop emp_subcontractors first (has foreign key to employees_subcontractors)
        Schema::dropIfExists('emp_subcontractors');
        
        // Drop employees_subcontractors
        Schema::dropIfExists('employees_subcontractors');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Recreate employees_subcontractors table
        Schema::create('employees_subcontractors', function (Blueprint $table) {
            $table->id();
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('state')->nullable();
            $table->string('suburb')->nullable();
            $table->date('dob')->nullable();
            $table->string('work_experience')->nullable();
            $table->string('trade_qualified')->nullable();
            $table->string('trade_qualified_year')->nullable();
            $table->string('trade_licensed')->nullable();
            $table->string('trade_licensed_year')->nullable();
            $table->string('year_commenced')->nullable();
            $table->integer('citizenship_status')->nullable();
            $table->string('visa_attachement')->nullable();
            $table->text('allergies')->nullable();
            $table->text('previous_injuries')->nullable();
            $table->text('medical_condition')->nullable();
            $table->string('medical_attachement_files')->nullable();
            $table->string('signature')->nullable();
            $table->string('profile_image')->nullable();
            $table->timestamps();
        });

        // Recreate emp_subcontractors table
        Schema::create('emp_subcontractors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('emp_id');
            $table->unsignedBigInteger('subcontractor_id');
            $table->unsignedBigInteger('company_id')->nullable();
            $table->json('project_ids')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
            
            $table->foreign('emp_id')->references('id')->on('employees_subcontractors')->onDelete('cascade');
            $table->foreign('subcontractor_id')->references('id')->on('users')->onDelete('cascade');
            
            $table->index('emp_id');
            $table->index('subcontractor_id');
            $table->index('company_id');
        });
    }
}
