<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesSubcontractorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees_subcontractors', function (Blueprint $table) {
            $table->id();

            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('state')->nullable();
            $table->string('suburb')->nullable();
            $table->date('dob')->nullable();
            $table->string('work_experience')->nullable();
            $table->string('trade_qualified')->nullable();
            $table->string('trade_qualified_year')->nullable();
            $table->string('trade_licensed')->nullable();
            $table->string('trade_licensed_year')->nullable();
            $table->string('year_commenced')->nullable();
            $table->integer('citizenship_status')->nullable();
            $table->string('visa_attachement')->nullable();
            $table->text('allergies')->nullable();
            $table->text('previous_injuries')->nullable();
            $table->text('medical_condition')->nullable();
            $table->string('medical_attachement_files')->nullable();
            $table->string('signature')->nullable();
            $table->string('profile_image')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees_subcontractors');
    }
}
