<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesSubcontractorsMetasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees_subcontractors_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('emp_id'); // Reference to employees_subcontractors table
            $table->unsignedBigInteger('subcontractor_id'); // Reference to users table (user_type = 5)
            $table->unsignedBigInteger('company_id')->nullable(); // Reference to customer/company
            $table->json('project_ids')->nullable(); // JSON array of project IDs
            $table->boolean('active')->default(true); // Active flag to enable/disable employee on company/project
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('emp_id')->references('id')->on('employees_subcontractors')->onDelete('cascade');
            $table->foreign('subcontractor_id')->references('id')->on('users')->onDelete('cascade');
            
            // Indexes for better query performance
            $table->index('emp_id');
            $table->index('subcontractor_id');
            $table->index('company_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees_subcontractors_metas');
    }
}
