<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateXeroPayslipHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('xero_payslip_history', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('employee_id');
            $table->string('xero_emp_id');
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('hours', 10, 2);
            $table->string('status')->default('DRAFT');
            $table->text('xero_response')->nullable(); // Store JSON response from Xero
            $table->string('xero_timesheet_id')->nullable(); // Store Xero timesheet ID if returned
            $table->timestamps();
            
            // Add indexes for better query performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('employee_id');
            $table->index('xero_emp_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('xero_payslip_history');
    }
}
