<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmergencyContactColumnsToEmployeesSubcontractorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees_subcontractors', function (Blueprint $table) {
            $table->string('relation')->nullable()->after('phone');
            $table->string('emergency_name')->nullable()->after('relation');
            $table->string('mobile')->nullable()->after('emergency_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees_subcontractors', function (Blueprint $table) {
            $table->dropColumn(['relation', 'emergency_name', 'mobile']);
        });
    }
}
