<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDefectIdsToSubcontractorCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->json('defect_ids')->nullable()->after('project_ids')->comment('Array of defect IDs assigned to this subcontractor');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_companies', function (Blueprint $table) {
            $table->dropColumn('defect_ids');
        });
    }
}
