<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddApprovalFieldsToSubcontractorRequiredDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_required_documents', function (Blueprint $table) {
            $table->string('approval_status')->default('pending')->after('value')->comment('pending, approved, rejected');
            $table->unsignedBigInteger('approved_by')->nullable()->after('approval_status')->comment('User ID who approved/rejected');
            $table->timestamp('approved_at')->nullable()->after('approved_by')->comment('When document was approved/rejected');
            
            // Add foreign key for approved_by
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_required_documents', function (Blueprint $table) {
            $table->dropForeign(['approved_by']);
            $table->dropColumn(['approval_status', 'approved_by', 'approved_at']);
        });
    }
}
