<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * 
     * This migration adds required_docs_status and induction_status columns 
     * to track document and induction completion per employee-customer relationship.
     * 
     * required_docs_status values (same as SubcontractorCompany):
     * - 0 = Required documents NOT uploaded (default)
     * - 1 = Required documents uploaded and approved
     * - 2 = Required documents were approved, but company added NEW documents after that
     * - 3 = Required documents uploaded but rejected by admin
     * - 4 = Required documents uploaded and pending admin approval
     * 
     * induction_status values:
     * - 0 = No induction documents signed (default)
     * - 1 = All required induction documents signed
     * - 2 = Company added NEW induction documents after prior completion
     * - 3 = Some induction documents signed, others still pending
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subcontractor_employee_invitations', function (Blueprint $table) {
            // Required documents status - same values as subcontractor_companies.required_docs_status
            $table->tinyInteger('required_docs_status')->default(0)
                ->after('status')
                ->comment('0=not uploaded, 1=approved, 2=new docs added, 3=rejected, 4=pending');
            
            // Induction status - tracks induction document completion
            $table->tinyInteger('induction_status')->default(0)
                ->after('required_docs_status')
                ->comment('0=not signed, 1=complete, 2=new docs added, 3=partial/pending');
            
            // Indexes for filtering by status
            $table->index('required_docs_status');
            $table->index('induction_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subcontractor_employee_invitations', function (Blueprint $table) {
            $table->dropIndex(['required_docs_status']);
            $table->dropIndex(['induction_status']);
            $table->dropColumn(['required_docs_status', 'induction_status']);
        });
    }
};
