<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectManagementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_management', function (Blueprint $table) {
            $table->id();
            $table->integer('project_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('assigned_emp_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('title')->nullable();
            $table->integer('prerequisite_task')->nullable();
            $table->text('description')->nullable();
            $table->string('priority')->nullable(); // low, medium, high, critical
            $table->integer('status')->default(0); // 0=open,1=in_progress,2=submitted,3=completed,4=approved,5=rejected,6=reassigned
            $table->enum('assignment_type', ['internal_employee', 'subcontractor', 'subcontractor_employee'])->default('internal_employee');
            $table->integer('subcontractor_id')->nullable();
            $table->date('due_date')->nullable();
            $table->text('completion_description')->nullable();
            $table->dateTime('completed_at')->nullable();
            $table->text('reject_reason')->nullable();
            $table->integer('created_by')->nullable();
            $table->string('created_by_type')->nullable();
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_management');
    }
}
