<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permissions', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('module_id')->nullable();
            $table->string('module_type')->nullable(); // 'module' or 'sub_module'
            $table->string('status')->default('active');
            $table->string('permission_code')->nullable();
            $table->string('del')->default('0');
            $table->timestamps();

            // Indexes for better query performance
            $table->index('module_id');
            $table->index('module_type');
            $table->unique('permission_code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permissions');
    }
}
