<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_permissions', function (Blueprint $table) {
            $table->id();
            $table->integer('permission_id')->nullable();
            $table->string('status')->nullable()->default('active');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('module_id')->nullable();
            $table->string('module_type')->nullable();
            $table->string('del')->nullable()->default('0');
            $table->integer('template_id')->nullable();

            $table->timestamps();


            
            // Indexes for better query performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('module_id');
            $table->index('module_type');
            $table->index('template_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_permissions');
    }
}
